/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.NwaysProperties;
import ibm.nways.jdm.Service;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class SystemComponent
extends UnicastRemoteObject
implements Service,
Runnable {
    public static final int DEFAULT_PORT = 2099;
    public static final int REPLACE_EXISTING = 0;
    public static final int SHUTDOWN_OLD_VERSION = 1;
    public static final int QUIT_IF_ALREADY_STARTED = 2;
    public static final String PROP_BASE_DIR = "baseDir";
    public static final String PROP_PROP_DIR = "jmaPropertiesSubDir";
    protected int componentPort = 2099;
    protected String componentName = "unknown";
    protected String componentDir;

    public void initialize() {
        Thread thread = new Thread(this);
        thread.setName(this.componentName);
        thread.start();
    }

    public void register(String string, int n, int n2) {
        Registry registry = null;
        String[] stringArray = null;
        this.componentName = string;
        this.componentPort = n;
        System.out.println(String.valueOf(this.componentName) + " - registering ...");
        try {
            registry = LocateRegistry.getRegistry(this.componentPort);
            stringArray = registry.list();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(this.componentName) + " - received " + exception.getClass().getName());
            System.out.println(String.valueOf(this.componentName) + " - registry not found or not accesible");
            System.out.println(String.valueOf(this.componentName) + " - starting new registry on port " + this.componentPort);
            try {
                registry = LocateRegistry.createRegistry(this.componentPort);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        boolean bl = false;
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals(this.componentName)) {
                    bl = true;
                }
                ++n3;
            }
        }
        if (bl) {
            System.out.println(String.valueOf(this.componentName) + " - already registered on this machine!");
            if (n2 == 2) {
                this.shutdown();
            }
        }
        if (!bl || n2 != 2) {
            try {
                registry.rebind(this.componentName, this);
                System.out.println(String.valueOf(this.componentName) + " - registered");
                return;
            }
            catch (ConnectException connectException) {
                System.out.println(String.valueOf(this.componentName) + " - unable to bind " + this.componentName + " to registry on this host");
                System.out.println(String.valueOf(this.componentName) + " - failed to initialize");
                System.out.println(connectException);
                connectException.printStackTrace();
                this.shutdown();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public void deregister() {
        Registry registry = null;
        try {
            System.out.println(String.valueOf(this.componentName) + " shutting down ...");
            registry = LocateRegistry.getRegistry(this.componentPort);
            registry.unbind(this.componentName);
            return;
        }
        catch (Exception exception) {
            System.out.println("Registry not found or not accesible on shutdown; received " + exception.getClass().getName());
            System.out.println("Assuming system is already gone");
            return;
        }
    }

    public void start() {
        System.out.println(String.valueOf(this.componentName) + " - starting ...");
        this.initialize();
    }

    public void shutdown() {
        this.deregister();
    }

    public String getName() {
        return this.componentName;
    }

    public void run() {
        this.register("dummy", 2099, 2);
        System.out.println("System component " + this.componentName + " did not implement run() method ... nothing to do");
    }

    public String getComponentDirectory(String string) {
        if (this.componentDir == null) {
            this.componentDir = SystemComponent.buildComponentDirectory(string);
        }
        return this.componentDir;
    }

    public static String buildComponentDirectory(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = SystemComponent.getComponentProperty(PROP_BASE_DIR, "");
        String string3 = SystemComponent.getComponentProperty(PROP_PROP_DIR, "");
        stringBuffer.append(string2);
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '/' && stringBuffer.charAt(stringBuffer.length() - 1) != '\\') {
            stringBuffer.append('/');
        }
        if (string3.startsWith("/") || string3.startsWith("\\")) {
            stringBuffer.append(string3.substring(1));
        } else {
            stringBuffer.append(string3);
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '/' && stringBuffer.charAt(stringBuffer.length() - 1) != '\\') {
            stringBuffer.append('/');
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            stringBuffer.append(string.substring(1));
        } else {
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '/' && stringBuffer.charAt(stringBuffer.length() - 1) != '\\') {
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    public static String getComponentProperty(String string, String string2) {
        String string3 = null;
        string3 = NwaysProperties.getNwaysProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }
}

